define(['angular', 'app', 'WeightFHIRService', 'BpPulseFHIRService', 'GlucoseFHIRService','CholesterolFHIRService','MoodFHIRService','FitnessActivityFHIRService','FitnessGoalsFHIRService'], function (angular, app) {
    "use strict";

    app.service('HealthMoodService', function (WeightFHIRService, BpPulseFHIRService, GlucoseFHIRService, CholesterolFHIRService, MoodFHIRService, FitnessActivityFHIRService,FitnessGoalsFHIRService) {
        var HealthMoodService = {};

        HealthMoodService.instances = {};

        HealthMoodService.instance = function (key) {
            if (!HealthMoodService.instances[key]) {
                switch (key) {
                    case 'bp-pulse':
                        HealthMoodService.instances[key] = BpPulseFHIRService;
                        break;
                    case 'weight':
                        HealthMoodService.instances[key] = WeightFHIRService;
                        break;
                    case 'glucose':
                        HealthMoodService.instances[key] = GlucoseFHIRService;
                        break;
                    case 'cholesterol':
                        HealthMoodService.instances[key] = CholesterolFHIRService;
                        break;
                    case 'mood':
                        HealthMoodService.instances[key] = MoodFHIRService;
                        break;
                    case 'fitness-activity':
                        HealthMoodService.instances[key] = FitnessActivityFHIRService;
                        break;
                    case 'fitness-goals':
                        HealthMoodService.instances[key] = FitnessGoalsFHIRService;
                        break;

                }
            }

            return HealthMoodService.instances[key];
        }

        return HealthMoodService;
    });
});